************************************************************************
* Robustness check for imputation of owner-occupied housing assets	 *
************************************************************************

* A) Use only housing surveys (1970-2012) for owner-occupied housing based on simplified imputation parameters depending on age groups and total income
* B) Use wealth surveys (1992-2012) for owner-occupied housing based on simplified imputation parameters depending on age groups and total income

set more off
clear 

foreach pas of  global yearliste{
	dis `pas'
	global year=`pas'
	
	set seed 1025075792
* I) Organize the data
***************************	
	
	* Capital income and assets from National Accounts 
		import excel using "$param/GGP2016DINAAppendixA.xlsx",first clear sheet("statacapital") cellrange(A7:R71) 
		* Transform all parameters into global 
				foreach var of varlist _all {
					quiet sum `var' if year==${year}
					global `var'=r(mean)
				}
				
	* Load the data
		use year- ndecl pac age pension_irpp_foy rente_irpp_foy salchom_irpp_foy nonsal_foy rfon_irpp_foy rfin_int_irpp_foy rfin_int_bar_irpp_foy rfin_div_irpp_foy rfin_irpp_foy using  "$wfrev/rev${year}.dta",clear
		merge 1:1 idindiv using "$wfrevtravcn/revtravcn${year}.dta",keepusing(nonsal_capital_cn)
		* Small adjustments
			* keep only taxable intesrest at the progressive schedule the  interet for comparabilty issues
			replace rfin_int_irpp_foy =rfin_int_bar_irpp_foy
			* capital component of business income at the household level
			bys idfoy: egen nonsal_capital_cn_foy=sum(nonsal_capital_cn)
			* Financial income and labor income
			if ${year}>1984 {
				gen rev_fin_irpp_foy=rfin_int_irpp_foy+rfin_div_irpp_foy
				gen rev_trav_irpp_foy=pension_irpp_foy+rente_irpp_foy+salchom_irpp_foy+nonsal_foy
			}
			if ${year}<=1984 {
				gen rev_fin_irpp_foy=rfin_irpp_foy
				gen rev_trav_irpp_foy=pension_irpp_foy+rente_irpp_foy+salchom_irpp_foy+nonsal_foy
			}
			gen rev_tot=rev_fin_irpp+rev_trav_irpp_foy+rfon_irpp_foy
			drop _merge nonsal_capital_cn rfin_int_bar_irpp_foy pension_irpp_foy rente_irpp_foy salchom_irpp_foy nonsal_foy
	
	keep year idfoy  pondn  age rev_tot idnum idindiv pac ndecl
	tempfile table
	save "`table'",replace
	keep if idnum==1 
	sort idfoy
					
* II) Imputation of owner-occupied housing assets	
*****************************************************	
	
	* II.A) Based on housing surveys (1970-2012)	
	*********************************************
		
		* 1) Variables used for imputations	
			* Age groups			
				capture drop q_age_pr
				gen q_age_pr = 1
				replace q_age_pr = 2 if age >24
				replace q_age_pr = 3 if age >30
				replace q_age_pr = 4 if age >39
				replace q_age_pr = 5 if age >49
				replace q_age_pr = 6 if age >54
				replace q_age_pr = 7 if age >60
				replace q_age_pr = 8 if age >65
				replace q_age_pr = 9 if age >70
				* Adjustment of age groups 
				replace q_age_pr=7 if inlist(q_age_pr,8,9) & year==1970
				replace q_age_pr=8 if inlist(q_age_pr,9) & ((year>1970 & year <=1973) | year==2002)
				replace q_age_pr=2 if inlist(q_age_pr,1) & year>=2006
				
			* Age groups*groups of total income		
				sort year pac q_age_pr rev_tot
				gen u=runiform() if rev_tot==0
				replace rev_tot=u if rev_tot==0
				
				gen pondvr=round(100*pondn) 
				bys year pac q_age_pr : cumul rev_tot [w=pondvr], gen (p100)
				replace p100=p100*100
				gen q_age_rev   = 0
				replace q_age_rev= 25   if p100 >=25 & p100 <50 & q_age_rev==0
				replace q_age_rev= 50   if p100 >=50 & p100 <75 & q_age_rev==0
				replace q_age_rev= 75   if p100 >=75 & p100 <90 & q_age_rev==0
				replace q_age_rev= 90   if p100 >=90 & p100 <95 & q_age_rev==0
				replace q_age_rev= 95   if p100 >=95 & p100 <99 & q_age_rev==0
				replace q_age_rev= 99   if p100 >=99 & q_age_rev==0
				drop p100 pondvr u
				* Adjustments
				* For less than 30 y.o : only 5% of homeowners => Need to agregate P95-99 and P99-100 into P95-100
				replace q_age_rev=95 if (q_age_pr<3) & (q_age_rev==95 | q_age_rev==99)
				replace q_age_rev=95 if (q_age_pr>7) & (q_age_rev==95 | q_age_rev==99) & year==2002		

		* 2) Merge imputations parameters of each groups
			if ${year}>2010 {
				tempfile temp
				save "`temp'"
				use "$param/Imputation/clef_immo_ENL.dta",clear
				keep if year==2010
				drop year
				tempfile cleftemp
				save "`cleftemp'",replace
				use "`temp'",clear
				merge m:1 q_age_pr q_age_rev using "`cleftemp'"
				erase "`cleftemp'"
				erase "`temp'"
				gen group=10000*q_age_pr+q_age_rev
			}
			if ${year}<=2010 {
				merge m:1 year q_age_pr q_age_rev using "$param/Imputation/clef_immo_ENL.dta"
				gen group=10000*q_age_pr+q_age_rev
			}
			drop if _merge==2
			drop _merge
			
		* 3) Imputation of owner-occupied housing assets and corresponding debts		
			gen rfon_owner_cn_foy=0
			gen patfon_owner_brut_cn_foy=0
			gen patfon_owner_net_cn_foy=0
			gen passif_owner_cn_foy=0
			gen owner=0
			
			* Extensive margin: detention of owner-occupied housing assets
				sort idfoy
				bys pac group: gen uni=runiform()
				gen pondvr=round(100*pondn) 
				sort pac group uni
				bys pac group : cumul uni [w=pondvr], gen (p100)
				drop uni pondvr
				replace owner=1 if prop_immo>=p100	& pac==0							

			* Intensive margin: imptued rents, owner-occupied housing assets, debts	
				bys group : egen pondtemp=sum(pondn) if owner==1
				replace rfon_owner_cn_foy=share_patimmo/100*${revfon_fictifNA}*1000000000/pondtemp if   owner==1
				replace patfon_owner_brut_cn_foy=share_patimmo/100*${patfon_owner_brutNA}*1000000000/pondtemp if owner==1	
				replace passif_owner_cn_foy=ratio_pass_owner*patfon_owner_brut_cn_foy if owner==1							
				* Housing debts consistent with NA level
					sum passif_owner_cn_foy [aw=pondn]
					gen ratio_temp=min(1,ratio_pass_owner*${passif_ownerNA}*1000000000/r(sum))
					replace passif_owner_cn_foy=ratio_temp*patfon_owner_brut_cn_foy
					* Adjustment if ratio_temp=1
					sum passif_owner_cn_foy [aw=pondn] if ratio_temp>0.95
					local passif_max=r(sum)
					sum passif_owner_cn_foy [aw=pondn] 
					local passif=r(sum)
					replace passif_owner_cn_foy=passif_owner_cn_foy*(${passif_ownerNA}*1000000000-`passif_max')/(`passif'-`passif_max') if ratio_temp<=0.95
				
				replace passif_owner_cn_foy= patfon_owner_brut_cn_foy if passif_owner_cn_foy>patfon_owner_brut_cn_foy
				replace patfon_owner_net_cn_foy=patfon_owner_brut_cn_foy-passif_owner_cn_foy
				drop q_age* group pondtemp owner p100 prop_immo share_patimmo ratio_temp ratio_pass_owner
			
			foreach var of newlist rfon_owner patfon_owner_brut patfon_owner_net passif_owner {
				rename `var'_cn_foy `var'_ENL		
			}
	
	
	* II.B) Based on wealth surveys (1992-2012) with simplied imputation parameters 	
	********************************************************************************
	if ${year}>=1992 {
		* 1) Variables used for imputations	
			* Age groups			
				capture drop q_age_pr
				gen q_age_pr = 1
				replace q_age_pr = 2 if age >24
				replace q_age_pr = 3 if age >30
				replace q_age_pr = 4 if age >39
				replace q_age_pr = 5 if age >49
				replace q_age_pr = 6 if age >54
				replace q_age_pr = 7 if age >60
				replace q_age_pr = 8 if age >65
				replace q_age_pr = 9 if age >70
				
			* Age groups*groups of total income				
				gen pondvr=round(100*pondn) 
				bys year pac q_age_pr : cumul rev_tot [w=pondvr], gen (p100)
				replace p100=p100*100
				gen q_age_rev   = 0
				replace q_age_rev= 25   if p100 >=25 & p100 <50 & q_age_rev==0
				replace q_age_rev= 50   if p100 >=50 & p100 <75 & q_age_rev==0
				replace q_age_rev= 75   if p100 >=75 & p100 <90 & q_age_rev==0
				replace q_age_rev= 90   if p100 >=90 & p100 <95 & q_age_rev==0
				replace q_age_rev= 95   if p100 >=95 & p100 <99 & q_age_rev==0
				replace q_age_rev= 99   if p100 >=99 & q_age_rev==0
				drop p100 pondvr 
				* Adjustments
				* For less than 30 y.o : only 5% of homeowners => Need to agregate P95-99 and P99-100 into P95-100
				replace q_age_rev=95 if  q_age_rev >=95 & (q_age_pr ==10 | q_age_pr ==1)

		* 2) Merge imputations parameters of each groups
			if ${year}>2010 {
				tempfile temp
				save "`temp'"
				use "$param/Imputation/clef_immo_EPrevtot.dta",clear
				keep if year==2010
				drop year
				tempfile cleftemp
				save "`cleftemp'",replace
				use "`temp'",clear
				merge m:1 q_age_pr q_age_rev using "`cleftemp'"
				erase "`cleftemp'"
				erase "`temp'"
				gen group=10000*q_age_pr+q_age_rev
			}
			if ${year}<=2010 {
				merge m:1 year q_age_pr q_age_rev using "$param/Imputation/clef_immo_EPrevtot.dta"
				gen group=10000*q_age_pr+q_age_rev
			}
			drop if _merge==2
			drop _merge
			
		* 3) Imputation of owner-occupied housing assets and corresponding debts		
			gen rfon_owner_cn_foy=0
			gen patfon_owner_brut_cn_foy=0
			gen patfon_owner_net_cn_foy=0
			gen passif_owner_cn_foy=0
			gen owner=0
			
			* Extensive margin: detention of owner-occupied housing assets
				sort idfoy
				bys pac group: gen uni=runiform()
				gen pondvr=round(100*pondn) 
				sort pac group uni
				bys pac group : cumul uni [w=pondvr], gen (p100)
				drop uni pondvr
				replace owner=1 if prop_immo>=p100	& pac==0							

			* Intensive margin: imptued rents, owner-occupied housing assets, debts	
				bys group : egen pondtemp=sum(pondn) if owner==1
				replace rfon_owner_cn_foy=share_patimmo/100*${revfon_fictifNA}*1000000000/pondtemp if   owner==1
				replace patfon_owner_brut_cn_foy=share_patimmo/100*${patfon_owner_brutNA}*1000000000/pondtemp if owner==1	
				replace passif_owner_cn_foy=ratio_pass_owner*patfon_owner_brut_cn_foy if owner==1							
				* Housing debts consistent with NA level
					sum passif_owner_cn_foy [aw=pondn]
					gen ratio_temp=min(1,ratio_pass_owner*${passif_ownerNA}*1000000000/r(sum))
					replace passif_owner_cn_foy=ratio_temp*patfon_owner_brut_cn_foy
					* Adjustment if ratio_temp=1
					sum passif_owner_cn_foy [aw=pondn] if ratio_temp>0.95
					local passif_max=r(sum)
					sum passif_owner_cn_foy [aw=pondn] 
					local passif=r(sum)
					replace passif_owner_cn_foy=passif_owner_cn_foy*(${passif_ownerNA}*1000000000-`passif_max')/(`passif'-`passif_max') if ratio_temp<=0.95
				
				replace passif_owner_cn_foy= patfon_owner_brut_cn_foy if passif_owner_cn_foy>patfon_owner_brut_cn_foy
				replace patfon_owner_net_cn_foy=patfon_owner_brut_cn_foy-passif_owner_cn_foy
				drop q_age* group pondtemp owner p100 prop_immo share_patimmo ratio_temp ratio_pass_owner
			
			foreach var of newlist rfon_owner patfon_owner_brut patfon_owner_net passif_owner {
				rename `var'_cn_foy `var'_EPrevtot		
			}
		}
	keep year idfoy  rfon* passif* patfon* pondn
	merge 1:m idfoy using "`table'" ,keepusing (idnum idindiv pac ndecl)
	drop _merge
	* Individualization of owner-occupied housing assets and merge other assets
	foreach var of newlist rfon_owner patfon_owner_brut patfon_owner_net passif_owner {
		replace `var'_ENL=`var'_ENL/2 if ndecl==2 & pac==0
		replace `var'_ENL=0 if pac==1 & idnum~=1
		if ${year}>=1992 {
			replace `var'_EPrevtot=`var'_EPrevtot/2 if ndecl==2 & pac==0
			replace `var'_EPrevtot=0 if pac==1 & idnum~=1
		}
	}
	merge 1:1 year idfoy idindiv using "$wfrevcapwealthcn/revcapwealthcn${year}.dta",keepusing(patfon_owner_net_cn pat_cn)
	drop _merge
	
	* Rounding errors and check
		foreach var of newlist patfon_owner_brut passif_owner   {
			sum `var'_ENL [aw=pondn]
			dis r(sum)/${`var'NA}/1000000000
			replace `var'_ENL=`var'_ENL*${`var'NA}*1000000000/r(sum)
			if ${year}>=1992 {
				sum `var'_EPrevtot [aw=pondn]
				dis r(sum)/${`var'NA}/1000000000
				replace `var'_EPrevtot=`var'_EPrevtot*${`var'NA}*1000000000/r(sum)
			}
		}
		
	* when using housing surveys
		gen pat_ENL=pat_cn-patfon_owner_net_cn+patfon_owner_brut_ENL-passif_owner_ENL
	* When using housing surveys with simplified imputation paramaters
		if ${year}>=1992 {
			gen pat_EPrevtot=pat_cn-patfon_owner_net_cn+patfon_owner_brut_EPrevtot-passif_owner_EPrevtot
		}
	drop patfon_owner_net_cn pat_cn 
sort idfoy idnum
keep year idfoy idnum idindiv pondn patfon* passif* pat*
order year idfoy idnum idindiv pondn pat*	patfon* passif*	
save "$wfrobust/Housing/robust_hous${year}.dta",replace			
macro drop passif_rentNA passif_ownerNA patfon_rent_brutNA patfon_owner_brutNA revfon_fictifNA revavieNA revfonNA revdivNA revliquNA revintNA patproNA patfin_intNA patfin_divNA patfin_avNA patfon_rent_netNA patfon_owner_netNA patfin_liquNA       

}


